#generated by nuc_master 
nuc_master = read.csv('~/data/nuc_master.csv')
nuc_master_sub = subset(nuc_master,cac_c40 > quantile(nuc_master$cac_c40,0.25) & wt_c40 > quantile(nuc_master$wt_c40,0.25) )

#define slow and fast nucleosomes in cac, control for final occupancy
q=seq(0.1,1,0.1)
nuc_master_sub$cac_c40_quantile = 1
for (j in 1:10) {
  l = quantile(nuc_master_sub$cac_c40,q[j])
  u = quantile(nuc_master_sub$cac_c40,q[j+1])
  idx = which(nuc_master_sub$cac_c40 > l & nuc_master_sub$cac_c40 <= u)
  nuc_master_sub$cac_c40_quantile[idx]=j+1
}

nuc_master_sub = nuc_master_sub[with(nuc_master_sub, order(cac_c40_quantile, cac_ATI)),]

nuc_master_sub$cac_dynamics = NA
for (i in 1:10) {
  a = which(nuc_master_sub$cac_c40_quantile==i)
  n=floor(length(a)/10)
  s=a[1:n]
  f=a[length(a)-n+1:length(a)]
  
  nuc_master_sub$cac_dynamics[f]='fast'
  nuc_master_sub$cac_dynamics[s]='slow'
  
}

cac_fast_nuc = subset(nuc_master_sub,cac_dynamics=='fast')
cac_slow_nuc = subset(nuc_master_sub,cac_dynamics=='slow')

#write.csv(cac_fast_nuc,file='~/data/cac_fast_nuc.csv',row.names = FALSE)
#write.csv(cac_slow_nuc,file='~/data/cac_slow_nuc.csv',row.names = FALSE)

#define fast and slow in WT
q=seq(0.1,1,0.1)
nuc_master_sub$wt_c40_quantile = 1
for (j in 1:10) {
  l = quantile(nuc_master_sub$wt_c40,q[j])
  u = quantile(nuc_master_sub$wt_c40,q[j+1])
  idx = which(nuc_master_sub$wt_c40 > l & nuc_master_sub$wt_c40 <= u)
  nuc_master_sub$wt_c40_quantile[idx]=j+1
}

nuc_master_sub = nuc_master_sub[with(nuc_master_sub, order(wt_c40_quantile, wt_ATI)),]

nuc_master_sub$wt_dynamics = NA
for (i in 1:10) {
  a = which(nuc_master_sub$wt_c40_quantile==i)
  n=floor(length(a)/10)
  s=a[1:n]
  f=a[length(a)-n+1:length(a)]
  
  nuc_master_sub$wt_dynamics[f]='fast'
  nuc_master_sub$wt_dynamics[s]='slow'
  
}

wt_fast_nuc = subset(nuc_master_sub,wt_dynamics=='fast')
wt_slow_nuc = subset(nuc_master_sub,wt_dynamics=='slow')

#write.csv(wt_fast_nuc,file='~/data/wt_fast_nuc.csv',row.names = FALSE)
#write.csv(wt_slow_nuc,file='~/data/wt_slow_nuc.csv',row.names = FALSE)


#aligning fast and slow nucleosomes

#to convert bam file to gr file
BAMtoGR <- function(bam,bai){
  library(Rsamtools)
  
  # Create parameters for scanBam
  what <- c("rname", "pos", "strand", "isize")
  param <- ScanBamParam(what = what)
  
  reads <- scanBam(file = bam, 
                   index = bai, 
                   param = param)
  # Convert reads to GR
  return (GRanges(seqnames = reads[[1]][['rname']],
                  ranges = IRanges(start = reads[[1]][['pos']], width = reads[[1]][['isize']]),
                  strand = reads[[1]][['strand']]))
}

#nucleosome with final occupancy belonging to each decile stacked separately
#and will be normalized later to ensure equal representation of each decile
cac_fast_list = list()
cac_slow_list = list()
for (i in 1:10) {
  cac_fast_list[[i]] = subset(nuc_master_sub,cac_dynamics=='fast' & cac_c40_quantile==i)
  cac_slow_list[[i]] = subset(nuc_master_sub,cac_dynamics=='slow' & cac_c40_quantile==i)
}

wt_fast_list = list()
wt_slow_list = list()
for (i in 1:10) {
  wt_fast_list[[i]] = subset(nuc_master_sub,wt_dynamics=='fast' & wt_c40_quantile==i)
  wt_slow_list[[i]] = subset(nuc_master_sub,wt_dynamics=='slow' & wt_c40_quantile==i)
}
#WT
#####
file_name = c('wt_pulse','wt_c10','wt_c15','wt_c20','wt_c40')
wt_fast_mtx_list = list('q1'=list(),'q2'=list(),'q3'=list(),'q4'=list(),'q5'=list(),
                        'q6'=list(),'q7'=list(),'q8'=list(),'q9'=list(),'q10'=list())
wt_slow_mtx_list = list('q1'=list(),'q2'=list(),'q3'=list(),'q4'=list(),'q5'=list(),
                        'q6'=list(),'q7'=list(),'q8'=list(),'q9'=list(),'q10'=list())

cac_fast_mtx_list = list('q1'=list(),'q2'=list(),'q3'=list(),'q4'=list(),'q5'=list(),
                        'q6'=list(),'q7'=list(),'q8'=list(),'q9'=list(),'q10'=list())
cac_slow_mtx_list = list('q1'=list(),'q2'=list(),'q3'=list(),'q4'=list(),'q5'=list(),
                        'q6'=list(),'q7'=list(),'q8'=list(),'q9'=list(),'q10'=list())

for(q in 1:10){
  for (j in 1:5) {
    file_name.bam = paste("~/data/bam_bai/",file_name[j],".bam", sep='')
    file_name.bam.bai = paste("~/data/bam_bai/",file_name[j],".bam.bai",sep='')
    #convet to genomic ranges 
    gr = BAMtoGR(file_name.bam,file_name.bam.bai)
    cat(paste('Finished converting to GR','\n'))
    mid.df_all=data.frame(chr=seqnames(gr),mid=start(gr)+floor(width(gr)/2),length=width(gr))
    
    chr_counts.m=matrix(0,250,601)
    
    for (i in 1:nrow(wt_slow_list[[q]])){
      mid.df=subset(mid.df_all,chr==wt_slow_list[[q]]$chr[i])
      
      counts.m=matrix(0,250,601)
      peak_i = floor(wt_slow_list[[q]]$peak[i])
      mid_nuc.df=subset(mid.df,mid>=(peak_i-300)&mid<=(peak_i+300))
      for (size in 1:250){
        mid_nuc_size.df=subset(mid_nuc.df,length==size)
        counts.m[(251-size),]=hist(mid_nuc_size.df$mid,seq(peak_i-300,peak_i+300+1,1),plot = F,right = F)$counts
      }
      if((i %% 500) == 0 ){
        cat(paste("nucleosome #",i,"\n"))
      }
      chr_counts.m=chr_counts.m+counts.m
    }
    cat(paste("Finishing file",j,"\n"))
    wt_slow_mtx_list[[q]][[j]]=chr_counts.m
  }
}

#repeat for loop for 1)WT slow, 2)cac fast and 3)cac slow 

# saveRDS(wt_fast_mtx_list,file='~/data/wt_fast_mtx_list.RDS')
# saveRDS(wt_slow_mtx_list,file='~/data/wt_slow_mtx_list.RDS')
# saveRDS(cac_fast_mtx_list,file='~/data/cac_fast_mtx_list.RDS')
# saveRDS(cac_fast_mtx_list,file='~/data/cac_slow_mtx_list.RDS')



#for supplemental 3 -- wt stack up using fast and slow nuc identified from cac 
######
file_name = c('wt_pulse','wt_c10','wt_c15','wt_c20','wt_c40')
wt_slow_mtx_list_cacFastSlow = list('pulse','c10','c15','c20','c40')
wt_fast_mtx_list_cacFastSlow = list('pulse','c10','c15','c20','c40')

for (j in 1:5) {
  file_name.bam = paste("~/data/bam_bai/",file_name[j],".bam", sep='')
  file_name.bam.bai = paste("~/data/bam_bai/",file_name[j],".bam.bai",sep='')
  gr = BAMtoGR(file_name.bam,file_name.bam.bai)
  cat(paste('Finished converting to GR','\n'))
  mid.df_all=data.frame(chr=seqnames(gr),mid=start(gr)+floor(width(gr)/2),length=width(gr))
  
  chr_counts.m=matrix(0,250,601)
  
  for (i in 1:nrow(cac_fast_nuc)){
    mid.df=subset(mid.df_all,chr==cac_fast_nuc$chr[i])
    
    counts.m=matrix(0,250,601)
    peak_i = floor(cac_fast_nuc$peak[i])
    mid_nuc.df=subset(mid.df,mid>=(peak_i-300)&mid<=(peak_i+300))
    for (size in 1:250){
      mid_nuc_size.df=subset(mid_nuc.df,length==size)
      counts.m[(251-size),]=hist(mid_nuc_size.df$mid,seq(peak_i-300,peak_i+300+1,1),plot = F,right = F)$counts
    }
    if((i %% 500) == 0 ){
      cat(paste("nucleosome #",i,"\n"))
    }
    chr_counts.m=chr_counts.m+counts.m
  }
  cat(paste("Finishing file",j,"\n"))
  wt_fast_mtx_list_cacFastSlow[[j]]=chr_counts.m
}
#repeat for loop for slow nuc 

#saveRDS(wt_fast_mtx_list_cacFastSlow,file='~/data/wt_fast_mtx_list_cacFastSlow.RDS')
#saveRDS(wt_fast_mtx_list_cacFastSlow,file='~/data/wt_slow_mtx_list_cacFastSlow.RDS')



